<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(array("message" => "Invalid JSON input"));
    exit;
}

if (isset($data['session_id']) && isset($data['Capture_Live_Location'])) {
    $session_id = $data['session_id'];
    $capture_live_location = $data['Capture_Live_Location'];

    // Verify if session_id exists
    $verify_stmt = $conn->prepare("SELECT id FROM yog_sessions WHERE id = ?");
    $verify_stmt->bind_param("i", $session_id);
    $verify_stmt->execute();
    $verify_stmt->store_result();

    if ($verify_stmt->num_rows > 0) {
        $verify_stmt->close();

        // Update session table with location data
        $update_stmt = $conn->prepare("UPDATE yog_sessions SET Capture_Live_Location = ? WHERE id = ?");
        $update_stmt->bind_param("si", $capture_live_location, $session_id);

        if ($update_stmt->execute()) {
            echo json_encode(array("message" => "Location updated successfully"));
        } else {
            echo json_encode(array("message" => "Failed to update location: " . $update_stmt->error));
            error_log("Failed to update location: " . $update_stmt->error);
        }

        $update_stmt->close();
    } else {
        echo json_encode(array("message" => "Invalid session_id"));
    }
} else {
    echo json_encode(array("message" => "Invalid input"));
}

$conn->close();
?>
